# Player: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B (as Player B)
# Meta-Round: 8
# Experiment: PMxPM, Run: 1
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek_V3_0324_PayoffMaximizer_B_MR8_strategy.txt
# LLM Suggested Fallback: D

def huggingface_DeepSeek_V3_0324_PayoffMaximizer_B_MR8(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    if not opp_history:
        return "D"  # Initial move: Defect
    
    opponent_code_lower = opponent_program_code.lower()
    
    # Check for deterministic opponent strategies
    if "always cooperate" in opponent_code_lower or "return 'c'" in opponent_code_lower:
        return "D"  # Exploit always-cooperate
    if "always defect" in opponent_code_lower or "return 'd'" in opponent_code_lower:
        return "C"  # Minimize losses against always-defect
    
    current_round = len(my_history) + 1
    
    if current_round == 2:
        if opp_history[0] == "C":
            return "D"  # Continue defecting if opponent cooperated first
        else:
            return "C"  # Switch to cooperate if opponent defected first
    
    if current_round <= 3:
        if opp_history.count("D") > 1:
            return "D"  # Punish if opponent defected more than once in first 3 rounds
    
    if current_round >= 8:
        return "D"  # Defect aggressively in final rounds
    
    # Mirror opponent's last move if not in initial or final rounds
    if current_round > 3 and current_round < 8:
        return opp_history[-1] if opp_history else "D"
    
    return "D"  # Default fallback